using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using VIRP.AHOBPR.BO;
using VIRP.AHOBPR.DAL;

namespace VIRP.AHOBPR.BLL
{
	public static partial class QUEUE_STATUSManager
	{
		#region Fields
		#endregion

		#region Properties
		#endregion

		#region Methods

		public static QUEUE_STATUS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int64 QUEUE_STATUS_ID)
		{
			QUEUE_STATUS objReturn = null;
			QUEUE_STATUSDB objDB = new QUEUE_STATUSDB();

			objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, QUEUE_STATUS_ID);

			return objReturn;
		}

		public static List<QUEUE_STATUS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<QUEUE_STATUS> objReturn = null;
			QUEUE_STATUSDB objDB = new QUEUE_STATUSDB();

			objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

			return objReturn;
		}

		public static Int64 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, QUEUE_STATUS objSave)
		{
			Int64 objReturn = 0;
			QUEUE_STATUSDB objDB = new QUEUE_STATUSDB();

			objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int64 QUEUE_STATUS_ID)
		{
			Boolean objReturn = false;
			QUEUE_STATUSDB objDB = new QUEUE_STATUSDB();

			objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, QUEUE_STATUS_ID);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, QUEUE_STATUS objDelete)
		{
			return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.QUEUE_STATUS_ID);
		}

        public static bool ProcessQueueBatch(string queuebatchid)
        {
            QUEUE_STATUS queueStatus = new QUEUE_STATUS();
            AHOBPRJsonDataManager jsonManager = new AHOBPRJsonDataManager();
            QUEUE_STATUSDB objDB = new QUEUE_STATUSDB();

            try
            {
                List<QUEUE_LITE> queue = objDB.GetQueue(queuebatchid);
                //TLB.TODO
                //AHOBPREmailService emailServiceManager = new AHOBPREmailService();
                int sendMessageType;
                StringCollection emailList = new StringCollection();
                foreach (QUEUE_LITE queueItem in queue)
                {
                    queueStatus = new QUEUE_STATUS();
                    queueStatus.QUEUE_ID = queueItem.QUEUE_ID;
                    queueStatus.REGISTRANT_ID = queueItem.REGISTRANT_ID == 0 ? null : queueItem.REGISTRANT_ID;
                    queueStatus.USER_ID = queueItem.USER_ID == 0 ? null : queueItem.USER_ID;
                    queueStatus.PROCESS_START_DATE = DateTime.Now;
                    queueStatus.PROCESS_STATUS = "completed";
                    queueStatus.CREATEDBY = queueItem.CREATEDBY;
                    queueStatus.UPDATEDBY = queueItem.CREATEDBY;

                    switch (queueItem.QUEUE_TYPE)
                    {
                        case AHOBPRGlobal.AhobprQueueTypeUserEmail:
                            CRS.BO.USERS userObject = CRS.BLL.USERSManager.GetItem(string.Empty, 0, (int)queueItem.USER_ID);
                            //AHOBPRUserManager userManager = new AHOBPRUserManager();
                            //DBO_USER userObject = userManager.GetDboUser((int)queueItem.USER_ID);
                            if (userObject == null)
                            {
                                queueStatus.PROCESS_ERROR = "User not found.";
                                queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                Save(string.Empty, 0, queueStatus);
                            }
                            else
                            {
                                if (string.IsNullOrEmpty(userObject.EMAIL_ADDRESS))
                                {
                                    queueStatus.PROCESS_ERROR = "Email address not found for the user.";
                                    queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                    Save(string.Empty, 0, queueStatus);
                                }
                                else
                                {
                                    string fullName = userObject.FIRST_NAME + " " + userObject.LAST_NAME;
                                    //TLB.TODO
                                    //emailServiceManager.SendEmailToUser(userObject.USER_ID, fullName, queueItem.ITEM_ID, userObject.EMAIL_ADDRESS, queueItem.CREATEDBY);
                                    queueStatus.PROCESS_ERROR = string.Empty;
                                    queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                    Save(string.Empty, 0, queueStatus);
                                }
                            }
                            break;
                        case AHOBPRGlobal.AhobprQueueTypeEmail:
                            //TLB.TODO
                            //sendMessageType = emailServiceManager.GetMessageType(queueItem.ITEM_ID);
                            //emailList = emailServiceManager.GetEmailListForRegistrant((int)queueItem.REGISTRANT_ID);

                            if (emailList.Count > 0)
                            {
                                //TLB.TODO
                                //emailServiceManager.SendEmailToRegistrant((int)queueItem.REGISTRANT_ID, queueItem.ITEM_ID, emailList, sendMessageType, queueItem.CREATEDBY);
                                queueStatus.PROCESS_ERROR = string.Empty;
                            }
                            else
                            {
                                queueStatus.PROCESS_ERROR = "Email address not found for the registrant.";
                            }
                            queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                            Save(string.Empty, 0, queueStatus);
                            break;
                        case AHOBPRGlobal.AhobprQueueTypeNotification:
                            jsonManager.CreateMessageJson(queueItem.REGISTRANT_ID.ToString(), queueItem.ITEM_ID.ToString(), queueItem.CREATEDBY);
                            queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                            Save(string.Empty, 0, queueStatus);
                            break;
                        case AHOBPRGlobal.AhobprQueueTypeFollowupQuestions:
                            bool exists = false;
                            REGISTRANTManager.AddFollowupQuestionsToOneReigstrant((int)queueItem.REGISTRANT_ID, queueItem.ITEM_ID, ref exists);
                            if (exists == false)
                            {
                                // create user form json
                                jsonManager.CreateUserFormJson(queueItem.REGISTRANT_ID.ToString(), queueItem.ITEM_ID.ToString(), queueItem.CREATEDBY);
                                queueStatus.PROCESS_ERROR = string.Empty;
                                queueStatus.PROCESS_DESCRIPTION = "User form JSON created for follow-up questionnaire.";
                                queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                Save(string.Empty, 0, queueStatus);

                                // add an admin flag
                                string adminFlagName = queueItem.ITEM_DESCRIPTION.Substring(queueItem.ITEM_DESCRIPTION.IndexOf("AdminFlagName:", StringComparison.Ordinal) + 15).Trim();
                                REGISTRANTManager.AddFlagToRegistrantByFlagName((int)queueItem.REGISTRANT_ID, adminFlagName, queueItem.CREATEDBY);
                                queueStatus.PROCESS_ERROR = string.Empty;
                                queueStatus.PROCESS_DESCRIPTION = "Admin flag added for follow-up questionnaire.";
                                queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                Save(string.Empty, 0, queueStatus);

                                // send email
                                string emailTemplateId = queueItem.ITEM_DESCRIPTION.Substring(17, queueItem.ITEM_DESCRIPTION.IndexOf(",", StringComparison.Ordinal) - queueItem.ITEM_DESCRIPTION.IndexOf(":", StringComparison.Ordinal) - 2).Trim();
                                if (string.IsNullOrEmpty(emailTemplateId) == false)
                                {
                                    //TLB.TODO
                                    //sendMessageType = emailServiceManager.GetMessageType(Convert.ToInt32(emailTemplateId));
                                    //emailList = emailServiceManager.GetEmailListForRegistrant((int)queueItem.REGISTRANT_ID);

                                    if (emailList.Count > 0)
                                    {
                                        //TLB.TODO
                                        //emailServiceManager.SendEmailToRegistrant((int)queueItem.REGISTRANT_ID, Convert.ToInt32(emailTemplateId), emailList, sendMessageType, queueItem.CREATEDBY);
                                        queueStatus.PROCESS_ERROR = string.Empty;
                                    }
                                    else
                                    {
                                        queueStatus.PROCESS_ERROR = "Email address not found for the registrant.";
                                    }
                                    queueStatus.PROCESS_DESCRIPTION = "Message sent for follow-up questionnaire.";
                                    queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                    Save(string.Empty, 0, queueStatus);
                                }

                                // send notification
                                jsonManager.CreateMessageJson(queueItem.REGISTRANT_ID.ToString(), emailTemplateId, queueItem.CREATEDBY);
                                queueStatus.PROCESS_ERROR = string.Empty;
                                queueStatus.PROCESS_DESCRIPTION = "Notification sent for follow-up questionnaire.";
                                queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                Save(string.Empty, 0, queueStatus);
                            }
                            break;
                        case AHOBPRGlobal.AhobprQueueTypeFlag:
                            if (queueItem.ITEM_ID > 0)
                            {
                                if (REGISTRANTManager.HasSubpopulationFlag((int)queueItem.REGISTRANT_ID, queueItem.ITEM_ID) == false)
                                {
                                    REGISTRANTManager.AddFlagToRegistrantByFlagId((int)queueItem.REGISTRANT_ID, queueItem.ITEM_ID, queueItem.CREATEDBY);
                                }
                            }
                            else
                            {
                                REGISTRANTManager.AddFlagToRegistrantByFlagName((int)queueItem.REGISTRANT_ID, queueItem.ITEM_DESCRIPTION, queueItem.CREATEDBY);
                            }
                            queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                            Save(string.Empty, 0, queueStatus);
                            break;
                    }
                }
                return true;
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                //_sharedManager.LogErrorMessage("Process Queue Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);

                queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                queueStatus.PROCESS_STATUS = "failed";
                queueStatus.PROCESS_ERROR = ex.Message;
                Save(string.Empty, 0, queueStatus);

                return false;
            }
        }

        #endregion
    }
}
